/*
 * 쐬: 2008/08/05
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaElement;

import zigen.plugin.db.ext.s2jdbc.properties.S2jdbcPropertyPage;


public class NewFormWizard extends AbstractWizard {
	
	NewFormWizardPage fPage;
	
	public void addPages() {
		fPage = new NewFormWizardPage(selection);
		
		// ftHg̃X[pNX擾Đݒ肷i͕svj
		try {
			javaProject = getJavaProject(selection.getFirstElement());
			if (javaProject != null) {
				String defaultSuperClass = javaProject.getResource().getPersistentProperty(new QualifiedName(S2jdbcPropertyPage.QUALIFIER, S2jdbcPropertyPage.KEY_FORM_SUPERCLASS));
				
				if (defaultSuperClass != null)
					fPage.setSuperClass(defaultSuperClass, true);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		addPage(fPage);
		addPage(new NewFormWizardPage2(selection));
	}
	
	@Override
	protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
		fPage.createType(monitor);
		if (javaProject != null && fPage != null) {
			javaProject.getResource().setPersistentProperty(new QualifiedName(S2jdbcPropertyPage.QUALIFIER, S2jdbcPropertyPage.KEY_FORM_SUPERCLASS), fPage.getSuperClass());
		}
	}
	
	@Override
	public IJavaElement getCreatedElement() {
		return fPage.getCreatedType();
	}
	
	@Override
	protected IResource getModifiedResource() {
		return fPage.getModifiedResource();
	}
	

}